const video = document.getElementById("customVideo");
const playButton = document.getElementById("customPlayButton");

// Function to toggle play/pause and show/hide the button
function togglePlayPause() {
    if (video.paused || video.ended) {
        video.play();
        playButton.style.display = "none";
    } else {
        video.pause();
        playButton.style.display = "block";
    }
}

// Event listeners
playButton.addEventListener("click", togglePlayPause);
video.addEventListener("click", togglePlayPause);

// Show play button when the video pauses
video.addEventListener("pause", () => {
    playButton.style.display = "block";
});

// Hide play button when the video starts
video.addEventListener("play", () => {
    playButton.style.display = "none";
});

