@push('styles')
<link rel="stylesheet" href="{{ asset('assets/css/about-us.styles.css') }}" type="text/css" />
@endpush

@extends('layouts.app')

@section('title', 'About Us | The Modern Hospital')

@section('content')

  {{-- Smooth wrapper (kept from your structure) --}}
  <div id="smooth-wrapper">
    <div id="smooth-content">

      {{-- About Us --}}
      <div class="main-page-header">
        <h1>The Modern Hospital</h1>
        <p>The Modern Hospital / About Us</p>
    </div>

    <!-- Text Block -->
    <div class="hospital-guide-wrapper">
        <div class="container">
            <div class="row about-section">
                <div class="col">
                    <div class="divider-header">
                        <h2>About Us</h2>
                        <div class="divider"></div>
                    </div>
                </div>
            </div>
            <div class="row about-bg align-items-start">
                <div class="col-lg-5">
                    <div class="about-thumb aos-init aos-animate" data-aos="fade-up-right">
                        <img src="{{ asset('assets/images/resource/home/about-img.png') }}" alt="">
                        <div class="thumbs-bxs">
                            <div class="icon">
                                <img class="logo-small" src="{{ asset('assets/images/resource/logo-small-1.png') }}"
                                    alt="">
                            </div>
                            <div class="text-circle">
                                <svg xmlns="http://www.w3.org/2000/svg" width="250.5" height="250.5"
                                    viewBox="0 0 250.5 250.5">
                                    <path d="M.25,125.25a125,125,0,1,1,125,125,125,125,0,0,1-125-125"
                                        id="e-path-35ee1b2"></path>
                                    <text>
                                        <textPath id="e-text-path-35ee1b2" href="#e-path-35ee1b2"
                                            startOffset="0%">
                                            DELIVERING CARE&nbsp;&nbsp;&nbsp;*&nbsp;&nbsp;BEYOND
                                            COMPARE&nbsp;&nbsp;&nbsp;*&nbsp;&nbsp;
                                        </textPath>
                                    </text>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 aos-init aos-animate" data-aos="fade-up-left">
                    <div class="mediic-section-title2">
                        <p>
                            The Modern Hospital is a not-for-profit hospital, founded in 2009 on the
                            belief
                            that healthcare is a sacred trust. Guided by our slogan, “Taluq Eman Ka”—The
                            Relation of Faith—we place humanity at the forefront of everything we do.
                            Whether caring for the most vulnerable or delivering advanced medical
                            treatments, we are committed to serving our community with compassion,
                            excellence, and integrity.
                        </p>

                        <p>
                            Located in the heart of Karachi, our 100-bed facility is designed to offer
                            top-tier medical and surgical services, with modern infrastructure that
                            supports both outpatient and inpatient care. In addition, we have a network
                            of 7 hospitals and 14+ clinics spread across Sindh, along with an off-campus
                            Sindh Modern College of Nursing & Health Sciences (SMCNHS)
                        </p>

                        <p>
                            Our highly skilled and dedicated team of medical professionals driven by
                            values of service and dignity, extends care beyond the hospital through home
                            healthcare and medicine delivery services, ensuring patients receive
                            continuous support at home.
                        </p>

                        <p>
                            Our highly skilled and dedicated team of medical professionals, driven by
                            values of service and dignity, is committed to providing the best patient
                            care. We offer 24/7 Emergency (ER), Laboratory, Radiology, Pharmacy, and
                            Home Healthcare Services, including laboratory test sample collection,
                            medicine delivery, and online consultations, ensuring that patients receive
                            continuous support at home.
                        </p>

                        <p>
                            To support those in financial need, The Modern Hospital offers Zakat and
                            Patient Welfare programs, providing equitable access to quality healthcare.
                        </p>

                        <p>
                            Recognized for our excellence, The Modern Hospital is accredited by Pakistan
                            nuclear Radiation authority(PNRA), and Sindh blood transfusion authority
                            (SBTA) affirming our commitment to the highest standards of patient safety
                            and diagnostic accuracy
                        </p>
                    </div>

                </div>

            </div>

        </div>
    </div>
    <div class="container-fluid" id="vison-mission">
        <div class="row">
            <div class="col-lg-12">
                <div class="row vision-cards g-3">
                    <div class="col-lg-4   vision-card-item">
                        <div class="vision-card">
                            <div class="header">
                                <div class="header-icon">
                                    <img src="{{ asset('assets/images/resource/about/mission_icon.png') }}" alt="">
                                    <h2>Mission</h2>
                                </div>
                                <p>
                                    Provide high-quality, compassionate, and ethical care to every
                                    patient
                                    with integrity and dignity, regardless of background.
                                </p>
                            </div>
                            <a href="#!">Read More <i class="bi bi-arrow-return-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-4   vision-card-item">
                        <div class="vision-card">
                            <div class="header">
                                <div class="header-icon">
                                    <img src="{{ asset('assets/images/resource/about/vivision_icon.png') }}" alt="">
                                    <h2>Vision</h2>
                                </div>
                                <p>
                                    To transform healthcare by upholding “Taluq Eman Ka” —The Relation
                                    of
                                    Faith, ensuring compassionate and equitable access for every
                                    individual.
                                </p>
                            </div>
                            <a href="#!">Read More <i class="bi bi-arrow-return-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-4   vision-card-item">
                        <div class="vision-card">
                            <div class="header">
                                <div class="header-icon">
                                    <img src="{{ asset('assets/images/resource/about/core_icon.png') }}" alt="">

                                    <h2>Core Value</h2>
                                </div>
                                <p>
                                    Excellence | Compassion |Integrity |Respect | Access
                                </p>

                            </div>
                            <a href="#!">Read More <i class="bi bi-arrow-return-right"></i></a>
                        </div>

                    </div>
                </div>
            </div>
            <div class="row " id="message-from-ceo">
                <div class="col-lg-12">
                    <div class="divider-header">
                        <h2>Message from CEO</h2>
                        <a href="">Read More <i class="bi bi-arrow-return-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid ceo-message">
        <div class="row">
            <div class="col-lg-5">
                <img src="{{ asset('assets/images/resource/about/message-from-ceo.png') }}" alt="">
            </div>
            <div class="col-lg-7 mt-5 mt-lg-0">
                <p>
                    Assalam O Alaikum
                    <br><br>
                    I am [CEO's Name], the CEO of The Modern Hospital, a network of hospitals and
                    clinics spread across Sindh, including Karachi, alongside our Modern Nursing
                    College.
                    <br><br>

                    At The Modern Hospital, we are proud to offer state-of-the-art medical facilities
                    equipped with the latest technology. Our dedicated and highly trained staff and
                    medical professionals are at the heart of our mission, working tirelessly to provide
                    exceptional patient care around the clock. From our 24/7 Emergency Room to our
                    Laboratory, Radiology, Pharmacy, and Home Healthcare Services—which include
                    laboratory test sample collection, medicine delivery, and online consultations—our
                    team is committed to meeting the diverse needs of our patients and their families.
                    <br><br>

                </p>
                <a href="#!" class="read-more-btn">Read more</a>
            </div>
        </div>
    </div>
    <div class="container-fluid accreditations" id="accreditations">
        <div class="row">
            <div class="col-lg-12">
                <div class="divider-header">
                    <h2>Accreditations</h2>
                    <a href="">Read More <i class="bi bi-arrow-return-right"></i></a>
                </div>

                <div class="accreditations-list">
                    <li>Joint Commission International Accreditation (JCIA)</li>
                    <li>College of American Pathologists (CAP) Accreditation</li>
                    <li>SafeCare Level 5 Certification</li>
                    <li>Sindh Healthcare Commission License</li>
                </div>

            </div>
        </div>
    </div>


      @endsection
