@push('styles')
<link rel="stylesheet" href="{{ asset('assets/css/find-a-doctor.styles.css') }}" type="text/css" />
@endpush

@extends('layouts.app')

@section('title', 'Find a Doctor | The Modern Hospital')

@section('content')
<div id="smooth-wrapper">
  <div id="smooth-content">

    <div class="main-page-header">
      <h1>Find a Doctor</h1>
      <p>The Modern Hospital / Doctors</p>
    </div>

    <div class="hospital-guide-wrapper">
      <div class="container">

        {{-- Filters: specialty, doctor name, keyword --}}
        <div class="row doctors-section">
          <div class="col-12 p-0">
            <div class="row">
              <div class="col-lg-12">
                <form class="doctor-filter_form" method="GET" action="{{ route('doctors.index') }}">
                  <div class="form-group">
                    <select class="form-control" id="specialty" name="specialty">
                      <option value="ALL" {{ ($specialty ?? 'ALL') === 'ALL' ? 'selected' : '' }}>All Specialties</option>
                      @foreach ($specialties as $opt)
                        <option value="{{ $opt }}" {{ ($specialty ?? '') === $opt ? 'selected' : '' }}>
                          {{ $opt }}
                        </option>
                      @endforeach
                    </select>
                    <label for="specialty">Specialty</label>
                  </div>

                  <div class="form-group">
                    <input type="text" class="form-control" id="doctor" name="doctor" value="{{ $name ?? '' }}" />
                    <label for="doctor">Doctor/Practitioner’s Name</label>
                  </div>

                  <div class="form-group">
                    <input type="text" class="form-control" id="keyword" name="keyword" value="{{ $keyword ?? '' }}" />
                    <label for="keyword">Keyword, organ or disease</label>
                  </div>

                  <div class="form_actions">
                    <button type="submit">
                      Search <i class="fa-solid fa-magnifying-glass"></i>
                    </button>
                    <a href="{{ route('doctors.index') }}">
                      View All <i class="bi bi-arrow-return-right"></i>
                    </a>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

        {{-- Results --}}
        <div class="row doctors-list_wrapper">
          <div class="col-12 doctors-list">
            @forelse ($doctors as $doc)
              <div class="doctor-list_item">
                <div class="doctor-card">
                  <h3 class="doctor-name">{{ ucwords(strtolower($doc['name'])) }}</h3>
                  <p class="doctor-specialty">
                    {{ strtoupper($doc['department']) }}
                    @if(!empty($doc['specialty'])) • {{ strtoupper($doc['specialty']) }} @endif
                  </p>

                  <div class="doctor-image">
                    <img src="{{ $doc['image'] }}" alt="{{ $doc['name'] }}">
                    <!-- <div class="overlay">
                      <div class="social-icons">
                        <a href="#"><i class="fab fa-whatsapp"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-facebook"></i></a>
                      </div>
                    </div> -->
                  </div>

                  <!-- @if(!empty($doc['education']))
                    <p class="mt-2"><strong>Education:</strong> {{ $doc['education'] }}</p>
                  @endif -->
                  <!-- @if(!empty($doc['contact']))
                    <p><strong>Contact:</strong> {{ $doc['contact'] }}</p>
                  @endif -->

                  <!-- @if(!empty($doc['schedule']))
                    <div class="doctor-schedule">
                      <strong>Schedule:</strong>
                      <ul class="schedule-list">
                        @foreach ($doc['schedule'] as $slot)
                          <li>{{ $slot['day'] }}: {{ \Illuminate\Support\Str::of($slot['start'])->limit(5, '') }} - {{ \Illuminate\Support\Str::of($slot['end'])->limit(5, '') }}</li>
                        @endforeach
                      </ul>
                    </div>
                  @endif -->

                </div>
              </div>
            @empty
              <p>No doctors found.</p>
            @endforelse
          @if($doctors instanceof \Illuminate\Pagination\LengthAwarePaginator)
            <div class="mt-4 d-flex justify-content-center">
                {{ $doctors->appends(request()->query())->onEachSide(1)->links('vendor.pagination.numbers-only') }}
            </div>
            @endif
          </div>
        </div>

      </div>
    </div>

@endsection
