@php
  // helper for active classes (matches path prefixes)
  $is = fn($pattern) => request()->is($pattern);
@endphp

<!-- Main Menu -->
<div id="sticky-header" class="mediic_nav_manu">
  <div class="container-fluid secondary-menu">
    <div class="row align-items-center">
      <div class="col-lg-12">
        <div id="top-nav">
          <ul class="top-nav_icons">
            <li class="top-nav_icon__item">
              <img src="{{ asset('assets/images/resource/contact-us-icon.svg') }}" alt="">
              <a class="{{ $is('contact-us') ? 'active' : '' }}" href="{{ url('/contact-us') }}">CONTACT US</a>
            </li>
            <li class="top-nav_icon__item">
              <img src="{{ asset('assets/images/resource/location-icon.svg') }}" alt="">
              <a href="#!">LOCATION</a>
            </li>
            <li class="top-nav_icon__item">
              <img src="{{ asset('assets/images/resource/ambulance-icon.svg') }}" alt="">
              <a class="{{ $is('ambulance-services-1') ? 'active' : '' }}" href="{{ url('/ambulance-services-1') }}">AMBULANCE</a>
            </li>
          </ul>

          <div class="header-button">
            <a href="#!">
              <img class="icon" src="{{ asset('assets/images/resource/nursing-college-icon.svg') }}" alt="">
              NURSING COLLEGE
              <div class="mediic-hover-btn hover-btn"></div>
              <div class="mediic-hover-btn hover-btn2"></div>
              <div class="mediic-hover-btn hover-btn3"></div>
              <div class="mediic-hover-btn hover-btn4"></div>
            </a>
            <a href="#!">
              Book an APPOINTMENT
              <img src="{{ asset('assets/images/resource/arrow.png') }}" alt="" />
              <div class="mediic-hover-btn hover-btn"></div>
              <div class="mediic-hover-btn hover-btn2"></div>
              <div class="mediic-hover-btn hover-btn3"></div>
              <div class="mediic-hover-btn hover-btn4"></div>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="divider secondary-menu-divider" style="border: 1px solid #B7B7B7; width: 100vw; margin: 10px auto; transform: translateX(-20px);"></div>

  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-lg-2">
        <div class="logo cursor-scale small">
          <a class="logo_img" href="{{ url('/') }}" title="The Modern Hospital">
            <img src="{{ asset('assets/images/resource/tmh-logo.png') }}" alt="logo" />
          </a>
          <a class="main_sticky" href="{{ url('/') }}" title="The Modern Hospital">
            <img src="{{ asset('assets/images/resource/tmh-logo.png') }}" alt="logo" />
          </a>
        </div>
      </div>

      <div class="col-xl-8 col-lg-10">
        <nav class="mediic_menu">
          <ul class="nav_scroll">
            {{-- ABOUT --}}
            <li class="{{ $is('about-us*') ? 'active' : '' }}">
              <a class="mdy-hover cursor-scale small" href="#!">ABOUT</a>
              <ul class="sub-menu">
                <li><a class="{{ $is('about-us') ? 'active' : '' }}" href="{{ url('/about-us') }}">About TMH</a></li>
                <li><a class="{{ $is('about-us#message-from-ceo') ? 'active' : '' }}" href="{{ url('/about-us#message-from-ceo') }}">Welcome by CEO</a></li>
                <li><a class="{{ $is('about-us#vison-mission') ? 'active' : '' }}" href="{{ url('/about-us#vison-mission') }}">Vision, Mission and Values</a></li>
                <li><a class="{{ $is('about-us#accreditations') ? 'active' : '' }}" href="{{ url('/about-us#accreditations') }}">Accreditations</a></li>
              </ul>
            </li>

            {{-- HOSPITALS --}}
            <li class="{{ $is('hospitals*') ? 'active' : '' }}">
              <a class="mdy-hover cursor-scale small" href="#!">HOSPITALS</a>
              <ul class="sub-menu">
                <li>
                  <a href="#!">TMH Karachi</a>
                  <ul class="sub-menu">
                    <li><a class="{{ $is('hospitals/karachi') ? 'active' : '' }}" href="{{ url('/hospitals/karachi') }}">About TMH Karachi</a></li>
                    <li><a href="#!">Virtual Tour</a></li>
                    <li><a class="{{ $is('hospital-guide') ? 'active' : '' }}" href="{{ url('/hospital-guide') }}">Hospital Guide</a></li>
                    <li><a class="{{ $is('hospital-facilities') ? 'active' : '' }}" href="{{ url('/hospital-facilities') }}">Hospital Facility</a></li>
                    <li><a class="{{ $is('hospital-admissions') ? 'active' : '' }}" href="{{ url('/hospital-admissions') }}">Hospital Admissions</a></li>
                    <li><a class="{{ $is('diagnostic-laboratory-service') ? 'active' : '' }}" href="{{ url('/diagnostic-laboratory-service') }}">Diagnostic & Laboratory Services</a></li>
                    <li><a class="{{ $is('pharmacy') ? 'active' : '' }}" href="{{ url('/pharmacy') }}">Pharmacy</a></li>
                    <li><a class="{{ $is('clinics-schedule') ? 'active' : '' }}" href="{{ url('/clinics-schedule') }}">Clinics and Schedule</a></li>
                  </ul>
                </li>
                <li><a class="{{ $is('hospitals/gharo') ? 'active' : '' }}" href="{{ url('/hospitals/gharo') }}">TMH Gharo</a></li>
                <li><a class="{{ $is('hospitals/hyderabad') ? 'active' : '' }}" href="{{ url('/hospitals/hyderabad') }}">TMH Hyderabad</a></li>
                <li><a class="{{ $is('hospitals/saeedabad') ? 'active' : '' }}" href="{{ url('/hospitals/saeedabad') }}">TMH New Saeedabad</a></li>
                <li><a class="{{ $is('hospitals/mirpurkhas') ? 'active' : '' }}" href="{{ url('/hospitals/mirpurkhas') }}">TMH Mirpurkhan</a></li>
                <li><a class="{{ $is('hospitals/mithi') ? 'active' : '' }}" href="{{ url('/hospitals/mithi') }}">TMH Mithi</a></li>
                <li><a class="{{ $is('hospitals/islamkot') ? 'active' : '' }}" href="{{ url('/hospitals/islamkot') }}">TMH Islamkot</a></li>
              </ul>
            </li>

            {{-- MEDICAL CENTERS --}}
            <li class="{{ $is('medical-centers*') || $is('pharmacies*') ? 'active' : '' }}">
              <a class="mdy-hover cursor-scale small" href="#!">MEDICAL CENTERS</a>
              <ul class="sub-menu">
                <li><a class="{{ $is('medical-centers') ? 'active' : '' }}" href="{{ url('/medical-centers') }}">Medical Centers</a></li>
                <li><a class="{{ $is('pharmacies') ? 'active' : '' }}" href="{{ url('/pharmacies') }}">Pharmacies</a></li>
              </ul>
            </li>

            {{-- LABORATORIES --}}
            <li class="{{ $is('laboratories*') ? 'active' : '' }}">
              <a class="mdy-hover cursor-scale small {{ $is('laboratories') ? 'active' : '' }}" href="{{ url('/laboratories') }}">LABORATORIES</a>
              <ul class="sub-menu">
                <li><a class="{{ $is('laboratories-packages') ? 'active' : '' }}" href="{{ url('/laboratories-packages') }}">Clinical Laboratories Packages</a></li>
                <li><a class="{{ $is('lab-sample-collection') ? 'active' : '' }}" href="{{ url('/lab-sample-collection') }}">Lab Sample Collection Request</a></li>
                <li><a class="{{ $is('find-laboratories') ? 'active' : '' }}" href="{{ url('/find-laboratories') }}">Find Your Nearest Laboratory</a></li>
                <li><a class="{{ $is('laboratory-test') ? 'active' : '' }}" href="{{ url('/laboratory-test') }}">Our Laboratory Test</a></li>
                <li><a href="#!">Covid – 19 Test</a></li>
              </ul>
            </li>

            {{-- HEALTH SOLUTIONS --}}
            <li class="{{ $is('health-solutions*') || $is('health-packages*') || $is('treatment-services*') || $is('home-health-services*') ? 'active' : '' }}">
              <a class="mdy-hover cursor-scale small" href="{{ url('/health-solutions') }}">HEALTH SOLUTIONS</a>
              <ul class="sub-menu">
                <li><a class="{{ $is('health-solutions') ? 'active' : '' }}" href="{{ url('/health-solutions') }}">Clinics</a></li>
                <li><a class="{{ $is('health-packages') ? 'active' : '' }}" href="{{ url('/health-packages') }}">Health Packages</a></li>
                <li><a class="{{ $is('treatment-services') ? 'active' : '' }}" href="{{ url('/treatment-services') }}">Treatments and Services</a></li>
                <li><a class="{{ $is('home-health-services') ? 'active' : '' }}" href="{{ url('/home-health-services') }}">Home Health Services</a></li>
                <li><a class="{{ $is('second-opinion-services') ? 'active' : '' }}" href="{{ url('/second-opinion-services') }}">Second Opinion Services</a></li>
                <li><a class="{{ $is('medical-travel-services') ? 'active' : '' }}" href="{{ url('/medical-travel-services') }}">Medical Travel Solutions</a></li>
              </ul>
            </li>

            {{-- PATIENT SERVICES --}}
            <li class="{{ $is('find-a-doctor*') || $is('plan-appointment*') || $is('available-payment-options*') || $is('referral-services*') ? 'active' : '' }}">
              <a class="mdy-hover cursor-scale small" href="#!">PATIENT SERVICES</a>
              <ul class="sub-menu">
                <li><a class="{{ $is('find-a-doctor') ? 'active' : '' }}" href="{{ url('/find-a-doctor') }}">Find a Doctor</a></li>
                <li><a class="{{ $is('plan-appointment') ? 'active' : '' }}" href="{{ url('/plan-appointment') }}">Prepare for Your Visit</a></li>
                <li><a class="{{ $is('available-payment-options') ? 'active' : '' }}" href="{{ url('/available-payment-options') }}">Payment Options</a></li>
                <li><a href="#!">Concierge Services</a></li>
                <li><a class="{{ $is('referral-services') ? 'active' : '' }}" href="{{ url('/referral-services') }}">Referral Services</a></li>
                <li><a class="{{ $is('ambulance-services-1') ? 'active' : '' }}" href="{{ url('/ambulance-services-1') }}">Ambulance Services</a></li>
              </ul>
            </li>

            {{-- PATIENT WELFARE --}}
            <li class="{{ $is('patient-welfare*') ? 'active' : '' }}">
              <a class="mdy-hover cursor-scale small" href="#!">PATIENT WELFARE</a>
              <ul class="sub-menu">
                <li><a href="#!">Welfare Support</a></li>
                <li><a href="#!">Zakat Support</a></li>
                <li><a href="#!">How to Apply</a></li>
                <li><a href="#!">Donate and Support</a></li>
              </ul>
            </li>
          </ul>
        </nav>
      </div>

      <div class="col-lg-2">
        <div class="mediic-right-side cursor-scale small">
          <div class="search-box-btn search-box-outer">
            <i class="fa-solid fa-magnifying-glass"></i>
          </div>
          <div class="sidebar">
            <div class="nav-btn navSidebar-button">
              <span><i class="bi bi-grid-3x3-gap-fill"></i></span>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

{{-- Mobile menu (kept from your original) --}}
<div class="mobile-menu-area sticky d-sm-block d-md-block d-lg-none">
    <div class="mobile-menu">
      <nav class="mediic_menu">
        <ul class="nav_scroll">
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">ABOUT </a>
            <ul class="sub-menu">
              <li><a href="!#">About TMH</a></li>
              <li><a href="!#">Welcome by CEO</a></li>
              <li><a href="!#">Vision, Mission and Values</a></li>
              <li><a href="!#">Accreditations</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">HOSPITALS </a>
            <ul class="sub-menu">
              <li><a href="/hospitals/karachi.html">THM Karachi</a></li>
              <li><a href="/hospitals/gharo.html">TMH Gharo</a></li>
              <li><a href="/hospitals/hyderabad.html">TMH Hyderabad</a></li>
              <li><a href="/hospitals/saeedabad.html">TMH New Saeedabad</a></li>
              <li><a href="/hospitals/mirpurkhas.html">TMH Mirpurkhan</a></li>
              <li><a href="/hospitals/mithi.html">TMH Mithi</a></li>
              <li><a href="/hospitals/islamkot.html">TMH Islamkot</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">MEDICAL CENTERS </a>
            <ul class="sub-menu">
              <li><a href="/medical-centers.html">Medical Centers</a></li>
              <li><a href="/pharmacies.html">Pharmacies</a></li>
            </ul>
          </li>
          <li>
            <a href="/laboratories.html">LABORATORIES</a>
            <ul class="sub-menu">
              <li><a href="/laboratories-packages.html">Clinical Laboratories Packages</a></li>
              <li><a href="/lab-sample-collection.html">Lab Sample Collection Request</a></li>
              <li><a href="/find-laboratories.html">Find Your Nearest Laboratory</a></li>
              <li><a href="/laboratory-test.html">Our Laboratory Test</a></li>
              <li><a href="!#">Covid – 19 Test</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="/health-solutions.html">HEALTH SOLUTIONS </a>
            <ul class="sub-menu">
              <li><a href="/health-solutions.html">Clinics</a></li>
              <li><a href="/health-packages.html">Health Packages</a></li>
              <li><a href="/treatment-services.html">Treatments and Services</a></li>
              <li><a href="/home-health-services.html">Home Health Services</a></li>
              <li><a href="/second-opinion-services.html">Second Opinion Services</a></li>
              <li><a href="/medical-travel-services.html">Medical Travel Solutions</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">PATIENT SERVICES </a>
            <ul class="sub-menu">
              <li><a href="/find-a-doctor.html">Find a Doctor</a></li>
              <li><a href="/plan-appointment.html">Prepare for Your Visit</a></li>
              <li><a href="/available-payment-options.html">Payment Options</a></li>
              <li><a href="!#">Concierge Services</a></li>
              <li><a href="/referral-services.html">Referral Services</a></li>
              <li><a href="ambulance-services-1.html">Ambulance Services</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">PATIENT WELFARE </a>
            <ul class="sub-menu">
              <li><a href="!#">Welfare Support</a></li>
              <li><a href="!#">Zakat Support</a></li>
              <li><a href="!#">How to Apply</a></li>
              <li><a href="!#">Donate and Support</a></li>
            </ul>
          </li>

        </ul>
      </nav>
    </div>
  </div>
