<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\DoctorController;

//Route::view('/', 'pages.home')->name('home');
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::view('/about-us', 'pages.about-us')->name('about-us');
Route::view('/contact-us', 'pages.contact-us')->name('contact-us');
//Route::view('/find-a-doctor', 'pages.find-a-doctor')->name('find-a-doctor');
Route::get('/find-a-doctor', [DoctorController::class, 'index'])->name('doctors.index');


// Dynamic route for hospitals folder:
// URL: /hospitals/{page} renders resources/views/hospitals/{page}.blade.php if it exists
Route::get('/hospitals/{page}', function ($page) {
    $view = "pages.hospitals.$page";
    if (view()->exists($view)) {
        return view($view);
    }
    abort(404);
})->name('pages.hospitals.show');

// Load admin routes (no provider needed)
require __DIR__ . '/admin.php';
